<?php
/**
 * @package Helix Ultimate Framework
 * @author JoomShaper https://www.joomshaper.com
 * @copyright Copyright (c) 2010 - 2018 JoomShaper
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
*/

defined ('_JEXEC') or die();

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Version;

HTMLHelper::addIncludePath(JPATH_COMPONENT . '/helpers');

$template = HelixUltimate\Framework\Platform\Helper::loadTemplateData();
$tmpl_params = $template->params;

$detail_center_content = $tmpl_params->get('detail_center_content');

$title_margin = $tmpl_params->get('blog_details_title_margin', 'default');
$title_margin_cls = $title_margin == 'default' ? 'uk-margin-top' : 'uk-margin-' . $title_margin . '-top';
$title_margin_cls .= $detail_center_content ? ' uk-text-center' : '';

$meta_margin = $tmpl_params->get('blog_details_meta_margin', 'default');
$meta_style = $tmpl_params->get('blog_details_meta_style', 'list');
$meta_margin_cls = $meta_margin == 'default' ? 'uk-margin-top' : 'uk-margin-' . $meta_margin . '-top';
$meta_margin_cls .= $detail_center_content ? ' uk-flex-center' : '';

$content_margin = $tmpl_params->get('blog_details_content_margin', 'default');
$content_margin_cls = $content_margin == 'default' ? 'uk-margin-top' : 'uk-margin-' . $content_margin . '-top';

$params = $this->params;

$version = new Version();
$JoomlaVersion = $version->getShortVersion();

?>

<div id="archive-items">
	<?php foreach ($this->items as $i => $item) : ?>
		<?php $info = $item->params->get('info_block_position', 0); ?>
		<div class="row<?php echo $i % 2; ?>" itemscope itemtype="https://schema.org/Article">
			<div class="page-header">
				<h2 class="<?php echo $title_margin_cls; ?> uk-margin-remove-bottom uk-article-title" itemprop="headline">
					<?php if ($params->get('link_titles')) : ?>
						<a href="<?php echo Route::_(version_compare($JoomlaVersion, '4.0.0', '>=') ? Joomla\Component\Content\Site\Helper\RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language) : ContentHelperRoute::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" itemprop="url">
							<?php echo $this->escape($item->title); ?>
						</a>
					<?php else : ?>
						<?php echo $this->escape($item->title); ?>
					<?php endif; ?>
				</h2>

				<?php // Content is generated by content plugin event "onContentAfterTitle" ?>
				<?php echo $item->event->afterDisplayTitle; ?>
			</div>
			
		<?php $useDefList = ($params->get('show_author') || $params->get('show_publish_date') || $params->get('show_category') || $params->get('show_parent_category')); ?>

		<?php // Author, Publish Date, Category ?>
		
		<?php 
			$author = $published = $category = '';
			if ($params->get('show_author') && !empty($item->author )) {
				$author = ($item->created_by_alias ?: $item->author);
				
				if (!empty($item->contact_link ) && $this->params->get('link_author') == true) {
					$author = HTMLHelper::_('link', $item->contact_link, $author);
				}
			}

			if ($params->get('show_publish_date')) {
				$published = HTMLHelper::_('date', $item->publish_up, Text::_('DATE_FORMAT_LC3'));
				$published = '<time datetime="' . HTMLHelper::_('date', $item->publish_up, 'c') . "\">$published</time>";
			}

			if ($params->get('show_category')) {
				$category = $item->category_title;
				if ($this->params->get('link_category') && !empty($item->catid)) {
					$category = '<a href="' . Route::_(version_compare($JoomlaVersion, '4.0.0', '>=') ? Joomla\Component\Content\Site\Helper\RouteHelper::getCategoryRoute($item->catslug) : ContentHelperRoute::getCategoryRoute($item->catslug)) . '" itemprop="genre">' . $category . '</a>';
				}
			}
		?>

		<?php if ($useDefList && $meta_style == 'list') : ?>
		<?php 
			$blocks = array_filter([
				$published ?: '',
				$author ? "<span>{$author}</span>" : '',
				$category ?: '',
			]);	
			?>
			<ul class="<?php echo $meta_margin_cls; ?> uk-margin-remove-bottom uk-subnav uk-subnav-divider">
				<?php foreach ($blocks as $block) : ?>
					<li><?= $block ?></li>
				<?php endforeach ?>
			</ul>
		<?php endif; ?>

		<?php if ($useDefList && $meta_style == 'sentence') : ?>
			<p class="<?php echo $meta_margin_cls; ?> uk-margin-remove-bottom uk-article-meta">
				<?php if ($author && $published) : ?>
					<?php Text::printf('TPL_META_AUTHOR_DATE', $author, $published); ?>
				<?php elseif ($author) : ?>
					<?php Text::printf('TPL_META_AUTHOR', $author); ?>
				<?php elseif ($published) : ?>
					<?php Text::printf('TPL_META_DATE', $published); ?>
				<?php endif; ?>

				<?php if ($category) : ?>
					<?php Text::printf('TPL_META_CATEGORY', $category); ?>
				<?php endif; ?>
			</p>
		<?php endif; ?>

		<?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
		<?php echo $item->event->beforeDisplayContent; ?>
		<?php if ($params->get('show_intro')) : ?>
			<div class="<?php echo $content_margin_cls; ?>" itemprop="articleBody"> <?php echo HTMLHelper::_('string.truncateComplex', $item->introtext, $params->get('introtext_limit')); ?> </div>
		<?php endif; ?>

		<?php if ($params->get('show_create_date') || $params->get('show_modify_date') || $params->get('show_hits')) : ?>
			<ul class="uk-list">
				<?php if ($params->get('show_create_date')) : ?>
					<li>
						<time datetime="<?php echo HTMLHelper::_('date', $this->item->created, 'c'); ?>" itemprop="dateCreated">
							<?php echo Text::sprintf('TPL_META_DATE_CREATED', HTMLHelper::_('date', $this->item->created, Text::_('DATE_FORMAT_LC3'))); ?>
						</time>
					</li>
				<?php endif ?>

				<?php if ($params->get('show_modify_date')) : ?>
					<li>
						<time datetime="<?php echo HTMLHelper::_('date', $this->item->modified, 'c'); ?>" itemprop="dateModified">
							<?php echo Text::sprintf('TPL_META_DATE_MODIFIED', HTMLHelper::_('date', $this->item->modified, Text::_('DATE_FORMAT_LC3'))); ?>
						</time>
					</li>
				<?php endif ?>

				<?php if ($params->get('show_hits')) : ?>
					<li>
						<meta content="UserPageVisits:<?php echo $item->hits; ?>" itemprop="interactionCount">
						<?php echo Text::sprintf('COM_CONTENT_ARTICLE_HITS', $item->hits); ?>
					</li>
				<?php endif ?>
			</ul>
		<?php endif ?>

		<?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
		<?php echo $item->event->afterDisplayContent; ?>
	</div>
	<?php endforeach; ?>
</div>

<?php if (($this->params->def('show_pagination', 1) == 1 || ($this->params->get('show_pagination') == 2)) && ($this->pagination->pagesTotal > 1)) : ?>

<div class="uk-text-center uk-margin-top">
	<?php if ($this->params->def('show_pagination_results', 1)) : ?>
		<p>
			<?php echo $this->pagination->getPagesCounter(); ?>
		</p>
	<?php endif; ?>

	<?php echo $this->pagination->getPagesLinks(); ?>
	
</div>

<?php endif; ?>